<?php 
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";
    
    include "include/controlloLogin.php";
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
        <title>Geecom Admin - riepilogo contabilità</title>
    </head>
  <body>
    
    <header>
        <?php 
            include "include/barraSuperiore.php";
            
            include "include/header.php";
            
            include "include/barraMenu.php";
        ?>
    </header>

    <main role="main" class="bg-light">
		<div id="dashboard" class="container-fluid">
			<div class="row">

				<!-- Colonna principale -->
				<div class="col-12 py-4">
					<?php 
						include "include/cruscottoContabilita.php";
				 
						$parametri = array("tabella"=>"geecAd_comunicazioni", "elementiPerPagina"=>10,"parametriRicerca"=>array(),"ajax"=>false);
						$ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca, "");
						$ricerca->setOrdinamento("ORDER BY id DESC");
					?>
					
				</div><!-- /Colonna principale -->
				
				<div class="row my-4">
					<div class="col-lg-6">
						<div class="card mb-4 accordion box-shadow-lite">
							<div class="card-header collapsed" data-toggle="collapse" href="#articoliPiuLetti">
								<a class="card-title">
									Ultime entrate
								</a>
							</div>
							<div id="articoliPiuLetti" class="collapse show">

								<div class="table-responsive">
									<table class="table table-sm">
										<thead>
											<tr>
												<th scope="col">#</th>
												<th scope="col">Tipo</th>
												<th scope="col">Oggetto</th>
												<th scope="col">Importo €</th>
												<th scope="col">Data emissione</th>
											</tr>
										</thead>
										<tbody>
											<?php 
												$queryDocumentiFiscaliEntrata = "SELECT * FROM geecAd_documentiContabili WHERE entrataUscita LIKE 'Entrata' AND tipo NOT LIKE 'preventivo' AND tipo NOT LIKE 'prima nota' ORDER BY id DESC LIMIT 25";
												$risDocumentiUscita           = $geecomDb->eseguiQueryLettura($queryDocumentiFiscaliEntrata);

												while($documento = $risDocumentiUscita->fetch_assoc()) {
													$oggetto = "";
													$queryVociDocumento = "SELECT * FROM geecAd_vociDocumentiContabili WHERE idDocumento={$documento["id"]}";
													$risVociDocumento = $geecomDb->eseguiQueryLettura($queryVociDocumento);
													while($voceDocumento = $risVociDocumento->fetch_assoc()) {
														$oggetto .= ($oggetto=="") ? $voceDocumento["quantita"]." x ".$voceDocumento["descrizione"] : ", ".$voceDocumento["quantita"]." x ".$voceDocumento["descrizione"];
													}
													?>
													<tr>
														<th scope="row" class="text-nowrap small"><?= $documento["id"] ?></th>
														<td><span class="badge badge-light"><?= $documento["tipo"] ?></span></td>
														<td><a href="creaDocumentoContabile.php?id=<?= $documento["id"] ?>"><b><?= $oggetto ?></b></a></td>
														<td><b class="text-success"><?= $documento["totale"] ?></b></td>
														<td><?= date("d/m/Y",strtotime($documento["dataEmissione"])) ?></td>
													</tr>
													<?php
												}
											?>
										</tbody>
									</table>
								</div>

							</div>
						</div>
					</div>
					<div class="col-lg-6">
						<div class="card mb-4 accordion box-shadow-lite">
							<div class="card-header collapsed" data-toggle="collapse" href="#ultimiCommenti">
								<a class="card-title">
									Ultime uscite
								</a>
							</div>
							<div id="ultimiCommenti" class="collapse show">
								<div class="table-responsive">
									<table class="table table-sm">
										<thead>
											<tr>
												<th scope="col">#</th>
												<th scope="col">Tipo</th>
												<th scope="col">Note</th>
												<th scope="col">Importo €</th>
												<th scope="col">Data pagamento</th>
											</tr>
										</thead>
										<tbody>
											<?php
												$queryDocumentiFiscaliEntrata = "SELECT * FROM geecAd_documentiContabili WHERE entrataUscita LIKE 'Uscita' AND tipo NOT LIKE 'preventivo' AND tipo NOT LIKE 'prima nota' ORDER BY id DESC LIMIT 25";
												$risDocumentiUscita           = $geecomDb->eseguiQueryLettura($queryDocumentiFiscaliEntrata);

												while($documento = $risDocumentiUscita->fetch_assoc()) {
													?>
													<tr>
														<th scope="row" class="text-nowrap small"><a href="creaDocumentoContabile.php?id=<?= $documento["id"] ?>"><b><?= $documento["id"] ?></b></a></th>
														<td><span class="badge badge-light"><?= $documento["tipo"] ?></span></td>
														<td><a href="creaDocumentoContabile.php?id=<?= $documento["id"] ?>"><b><?= strip_tags($documento["testo"]) ?></b></a></td>
														<td><b class="text-danger"><?= $documento["totale"] ?></b></td>
														<td><?= date("d/m/Y",strtotime($documento["dataPagamento"])) ?></td>
													</tr>
													<?php
												}
											?>
										</tbody>
									</table>
								</div>

							</div>
						</div>
					</div>	
				</div>
			</div>
		</div>
    </main>

    <?php 
        include "include/footer.php";
        
        include "include/modal/modalMenuComponenti.php";
    ?>
	  
    <!-- modal cambia password -->
    <div class="modal fade" id="agg-componenti" tabindex="-1" role="dialog" aria-labelledby="aggiungi un componente" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Aggiungi un componente</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                </div>
            </div>
        </div>
    </div>
    <?php 
        include "include/jsBaseAreaAmministrativa.php";
    ?>
  </body>
</html>
